require("stategraphs/commonstates")

local events=
{
	EventHandler("attacked", function(inst, data)
        --V2C: health check since corpse shares this SG
		if inst.components.health and not inst.components.health:IsDead() then
			if CommonHandlers.TryElectrocuteOnAttacked(inst, data) then
				return
			elseif not (inst.sg:HasAnyStateTag("nointerrupt", "attack", "electrocute") or
						CommonHandlers.HitRecoveryDelay(inst, nil, math.huge)) --hit delay only for projectiles
			then
				inst.sg:GoToState("hit")
			end
		end
	end),
	EventHandler("doattack", function(inst)
		if not inst.components.health:IsDead() and ((inst.sg:HasStateTag("hit") and not inst.sg:HasStateTag("electrocute")) or not inst.sg:HasStateTag("busy")) then
			inst.sg:GoToState("attack")
		end
	end),
    CommonHandlers.OnSleep(),
    CommonHandlers.OnLocomote(false,true),
    CommonHandlers.OnFreeze(),
	CommonHandlers.OnElectrocute(),
    CommonHandlers.OnSink(),
    CommonHandlers.OnFallInVoid(),
    CommonHandlers.OnDeath(),

	-- Corpse handlers
	CommonHandlers.OnCorpseChomped(),
}

local states=
{
    State{
        name = "idle",
        tags = {"idle", "canrotate"},
        onenter = function(inst, playanim)
            inst.Physics:Stop()
			inst.AnimState:PlayAnimation("idle", true)
			if math.random() < .2 then
				inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/scream_short")
			end
        end,

        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },

    State{
        name = "attack",
		tags = { "attack", "busy" },

        onenter = function(inst, cb)
            inst.Physics:Stop()
            inst.components.combat:StartAttack()
            inst.AnimState:PlayAnimation("atk")
        end,

        timeline=
        {
            TimeEvent(0*FRAMES, function(inst) inst:PerformBufferedAction() inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/attack") end),
            TimeEvent(25*FRAMES, function(inst) inst:PerformBufferedAction() inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/attack_grunt") end),
            TimeEvent(28*FRAMES, function(inst) inst:PerformBufferedAction() inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/swipe") end),
            TimeEvent(28*FRAMES, function(inst) inst.components.combat:DoAttack() end),
        },

        events=
        {
            EventHandler("animover", function(inst)inst.sg:GoToState("idle") end),
        },
    },

  	State{
		name = "hit",
        tags = {"busy", "hit"},

        onenter = function(inst, cb)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("hit")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/hurt")
			CommonHandlers.UpdateHitRecoveryDelay(inst)
        end,

        events=
        {
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },

	State{
		name = "taunt",
        tags = {"busy"},

        onenter = function(inst, cb)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("taunt")
            inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/scream")
        end,

        events=
        {
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },

	State{
		name = "makenest",
        tags = {"busy", "nointerrupt"},

        onenter = function(inst, cb)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("cocoon")
            --inst.SoundEmitter:PlaySound("dontstarve/creatures/krampus/taunt")
        end,

		timeline=
        {
            TimeEvent(15*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/scream") end),
        },

        events=
        {
			EventHandler("animover", function(inst)
				inst.Physics:ClearCollisionMask()
				inst:Remove()
				local den = SpawnPrefab("spiderden")
				den.AnimState:PlayAnimation("cocoon_small")
				den.Transform:SetPosition(inst.Transform:GetWorldPosition())
			end),
        },
    },


	State{
		name = "birth",
        tags = {"busy", "nointerrupt"},

        onenter = function(inst, cb)
            inst.AnimState:PlayAnimation("enter")
			inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/emerge_voice")
			inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/emerge_foley")
		end,

		timeline=
        {
        },


        events=
        {
			EventHandler("animover", function(inst)
				inst.sg:GoToState("idle")
			end),
        },
    },

	State{
		name = "poop_pre",
        tags = {"busy", "nointerrupt"},

        onenter = function(inst, cb)
            inst.Physics:Stop()
            inst.components.locomotor:Stop()
            inst.AnimState:PlayAnimation("poop_pre")

        end,

        timeline=
        {
            TimeEvent(20*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/scream_short") end),
        },

        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("poop_loop") end),
        },
    },

    State{
        name = "poop_loop",
        tags = {"busy", "nointerrupt"},

        onenter = function(inst, cb)
            inst.Physics:Stop()
            inst.components.locomotor:Stop()
            local angle = TheCamera:GetHeadingTarget()*DEGREES -- -22.5*DEGREES
            inst.Transform:SetRotation(angle / DEGREES)
            inst.AnimState:PlayAnimation("poop_loop")

        end,

        timeline=
        {
            TimeEvent(4*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/givebirth_voice") end),

            TimeEvent(8*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/givebirth_foley") end),
            TimeEvent(10*FRAMES, function(inst)
                if inst.components.incrementalproducer then
                    inst.components.incrementalproducer:TryProduce()
                end
            end),
        },

        events=
        {
            EventHandler("animover", function(inst)
                if inst.components.incrementalproducer and inst.components.incrementalproducer:CanProduce() then
                    inst.sg:GoToState("poop_loop")
                else
                    inst.sg:GoToState("poop_pst")
                end
            end),
        },
    },

    State{
        name = "poop_pst",
        tags = {"busy", "nointerrupt"},

        onenter = function(inst, cb)
            inst.Physics:Stop()
            inst.components.locomotor:Stop()
            local angle = TheCamera:GetHeadingTarget()*DEGREES -- -22.5*DEGREES
            inst.Transform:SetRotation(angle / DEGREES)
            inst.AnimState:PlayAnimation("poop_pst")

        end,
        events=
        {
			EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },

	State{
        name = "death",
        tags = {"busy"},

        onenter = function(inst)
            inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/die")
            inst.AnimState:PlayAnimation("death")
            inst.components.locomotor:StopMoving()
            RemovePhysicsColliders(inst)
            inst:DropDeathLoot()
        end,

        events =
        {
            CommonHandlers.OnCorpseDeathAnimOver(),
        },
    },
}

CommonStates.AddSleepStates(states,
	{
		sleeptimeline = {
	        TimeEvent(30*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/sleeping") end),
		},
	},
	{
		onsleep = function(inst)
			inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/fallasleep")
		end,
		onwake = function(inst)
			inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/wakeup")
		end
	}
)

CommonStates.AddWalkStates(states,
{
	walktimeline = {
		TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/walk_spiderqueen") end),
		TimeEvent(7*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/walk_spiderqueen") end),
		TimeEvent(10*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/walk_spiderqueen") end),
		TimeEvent(13*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/walk_spiderqueen") end),
		TimeEvent(17*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/walk_spiderqueen") end),
		TimeEvent(25*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/walk_spiderqueen") end),
		TimeEvent(32*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/walk_spiderqueen") end),
		TimeEvent(38*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/spiderqueen/walk_spiderqueen") end),
	},
})

CommonStates.AddFrozenStates(states)
CommonStates.AddElectrocuteStates(states)
CommonStates.AddSinkAndWashAshoreStates(states)
CommonStates.AddVoidFallStates(states)
CommonStates.AddCorpseStates(states)

-- Mutated den doesn't have a stategraph, so we handle that a bit uniquely!
CommonStates.AddLunarPreRiftMutationStates(states,
{
    mutate_timeline = {
        SoundFrameEvent(3, "lunarhail_event/creatures/lunar_mutation/mutate_crack_fleshy"),
        SoundFrameEvent(4, "lunarhail_event/creatures/lunar_mutation/mutate_crack_small"),
        SoundFrameEvent(17, "lunarhail_event/creatures/lunar_mutation/mutate_crack_small"),
        SoundFrameEvent(19, "lunarhail_event/creatures/lunar_mutation/mutate_crack_thump_small"),
        SoundFrameEvent(35, "lunarhail_event/creatures/lunar_mutation/mutate_crack_thump"),
        SoundFrameEvent(33, "lunarhail_event/creatures/lunar_mutation/mutate_crack_fleshy"),
        SoundFrameEvent(38, "lunarhail_event/creatures/lunar_mutation/mutate_crack_small"),
        SoundFrameEvent(43, "lunarhail_event/creatures/lunar_mutation/mutate_crack_thump_small"),
        SoundFrameEvent(50, "lunarhail_event/creatures/lunar_mutation/mutate_crack_thump"),
        SoundFrameEvent(55, "lunarhail_event/creatures/lunar_mutation/mutate_crack_thump"),
        SoundFrameEvent(62, "lunarhail_event/creatures/lunar_mutation/mutate_crack_thump"),
        SoundFrameEvent(63, "lunarhail_event/creatures/lunar_mutation/mutate_crack_small"),
        SoundFrameEvent(63, "lunarhail_event/creatures/lunar_mutation/mutate_rip_pre_31f"),
        SoundFrameEvent(63, "lunarhail_event/creatures/lunar_mutation/mutate_crack_fleshy"),
        SoundFrameEvent(66, "lunarhail_event/creatures/lunar_mutation/mutate_crack"),
        SoundFrameEvent(67, "lunarhail_event/creatures/lunar_mutation/mutate_crack_thump_small"),
        SoundFrameEvent(68, "lunarhail_event/creatures/lunar_mutation/mutate_crack_fleshy"),
        SoundFrameEvent(71, "lunarhail_event/creatures/lunar_mutation/mutate_crack"),
        SoundFrameEvent(73, "lunarhail_event/creatures/lunar_mutation/mutate_crack_thump_small"),
        SoundFrameEvent(75, "lunarhail_event/creatures/lunar_mutation/mutate_crack"),
        SoundFrameEvent(77, "lunarhail_event/creatures/lunar_mutation/mutate_crack_thump_small"),
        SoundFrameEvent(79, "lunarhail_event/creatures/lunar_mutation/mutate_crack_thump_small"),
        SoundFrameEvent(80, "lunarhail_event/creatures/lunar_mutation/mutate_crack"),
        SoundFrameEvent(81, "lunarhail_event/creatures/lunar_mutation/mutate_crack_small"),
        SoundFrameEvent(82, "lunarhail_event/creatures/lunar_mutation/mutate_crack_fleshy"),
        SoundFrameEvent(83, "lunarhail_event/creatures/lunar_mutation/mutate_crack"),
        SoundFrameEvent(85, "lunarhail_event/creatures/lunar_mutation/mutate_crack_thump_small"),
        SoundFrameEvent(89, "lunarhail_event/creatures/lunar_mutation/mutate_crack_small"),
        SoundFrameEvent(91, "lunarhail_event/creatures/lunar_mutation/mutate_crack"),
        SoundFrameEvent(91, "lunarhail_event/creatures/lunar_mutation/mutate_crack_fleshy"),

        SoundFrameEvent(94, "lunarhail_event/creatures/lunar_mutation/mutate_rip"),
    },
},
{
    mutate = "spider_queen_reviving",
},
nil, -- fns
{
    mutated_spawn_timing = 93 * FRAMES,
})

CommonStates.AddInitState(states, "idle")

return StateGraph("spiderqueen", states, events, "init")
